<?php
class Hacker {
    private $iv;
    
    public function __construct() {
        // IV ثابت (16 بایت صفر)
        $this->iv = str_repeat("\0", 16);
    }
    
    public function f($key_str) {
        // تابع تولید کلید از رشته متنی
        if (strlen($key_str) < 32) {
            $repeats = (int)(32 / strlen($key_str)) + 1;
            $key_str = substr(str_repeat($key_str, $repeats), 0, 32);
        }
        
        $key_str = str_pad(substr($key_str, 0, 32), 32, 'a');
        
        $substring = substr($key_str, 0, 8);
        $substring2 = substr($key_str, 8, 8);
        $substring3 = substr($key_str, 16, 8);
        $substring4 = substr($key_str, 24, 8);
        
        $transformed = $substring3 . $substring . $substring4 . $substring2;
        
        $result_chars = [];
        for ($i = 0; $i < strlen($transformed); $i++) {
            $char = $transformed[$i];
            if ($char >= '0' && $char <= '9') {
                $new_digit = ((ord($char) - 48) + 5) % 10;
                $result_chars[] = chr($new_digit + 48);
            } elseif ($char >= 'a' && $char <= 'z') {
                $new_char = ((ord($char) - 97) + 9) % 26;
                $result_chars[] = chr($new_char + 97);
            } else {
                $result_chars[] = $char;
            }
        }
        
        return implode('', $result_chars);
    }
    
    public function b($encrypted_data, $key_str) {
        // رمزگشایی AES-CBC
        try {
            $encrypted_bytes = base64_decode($encrypted_data);
            $key = $this->f($key_str);
            
            if (strlen($key) !== 32) {
                $key = str_pad($key, 32, "\0");
            }
            
            $cipher = "aes-256-cbc";
            $decrypted = openssl_decrypt(
                $encrypted_bytes,
                $cipher,
                $key,
                OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING,
                $this->iv
            );
            
            if ($decrypted === false) {
                return "";
            }
            
            // حذف padding
            $padding_length = ord($decrypted[strlen($decrypted) - 1]);
            if ($padding_length > 0 && $padding_length <= 16) {
                $decrypted = substr($decrypted, 0, -$padding_length);
            }
            
            return trim($decrypted);
        } catch (Exception $e) {
            error_log("خطای رمزگشایی: " . $e->getMessage());
            return "";
        }
    }
    
    public function d($data, $key_str) {
        // رمزنگاری AES-CBC
        try {
            $key = $this->f($key_str);
            
            if (strlen($key) !== 32) {
                $key = str_pad($key, 32, "\0");
            }
            
            // Padding داده
            $block_size = 16;
            $padding = $block_size - (strlen($data) % $block_size);
            $data .= str_repeat(chr($padding), $padding);
            
            $cipher = "aes-256-cbc";
            $encrypted = openssl_encrypt(
                $data,
                $cipher,
                $key,
                OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING,
                $this->iv
            );
            
            return base64_encode($encrypted);
        } catch (Exception $e) {
            error_log("خطای رمزنگاری: " . $e->getMessage());
            return "";
        }
    }
}
?>