<?php
require_once 'config.php';
require_once 'shad_api.php';

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['phone'])) {
    $phone = sanitize_input($_POST['phone']);
    
    // اعتبارسنجی شماره تلفن
    if (!preg_match('/^09[0-9]{9}$/', $phone)) {
        $response['message'] = 'شماره تلفن معتبر نیست (باید ۱۱ رقمی و با ۰۹ شروع شود)';
    } else {
        $app = new ShadApp();
        $result = $app->sendCode($phone);
        
        if ($result['success']) {
            // هدایت به صفحه وارد کردن کد
            header('Location: verify_code.php');
            exit();
        } else {
            $response = $result;
        }
    }
} else {
    $response['message'] = 'درخواست نامعتبر';
}

// اگر خطایی رخ داد
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>خطا در ارسال کد</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-exclamation-triangle"></i> خطا در ارسال کد</h1>
        </div>
        
        <div class="card error-card">
            <div class="error-icon">
                <i class="fas fa-times-circle"></i>
            </div>
            <h2>عملیات ناموفق بود</h2>
            <p class="error-message"><?php echo htmlspecialchars($response['message']); ?></p>
            
            <div class="actions">
                <a href="index.html" class="btn btn-primary">
                    <i class="fas fa-arrow-right"></i> بازگشت به صفحه اصلی
                </a>
            </div>
        </div>
    </div>
</body>
</html>