<?php
require_once 'config.php';
require_once 'shad_api.php';

// دریافت قالب ذخیره شده
$selected_template = getSelectedMessageTemplate();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>ارسال توکن</title>
    <script>
        // تابع دریافت قالب ذخیره شده از localStorage
        function getSavedTemplate() {
            const savedTemplate = localStorage.getItem('shad_message_template');
            return savedTemplate ? parseInt(savedTemplate) : 1;
        }
        
        // هنگام ارسال توکن
        async function sendToken() {
            const targetGuid = document.getElementById('target_guid').value;
            const templateId = getSavedTemplate(); // دریافت قالب از localStorage
            
            const response = await fetch('shad_app.php?action=send_token&target=' + encodeURIComponent(targetGuid) + '&template=' + templateId);
            const data = await response.json();
            
            // نمایش نتیجه
            alert(data.message);
        }
        
        // نمایش قالب فعلی
        window.onload = function() {
            const templateNames = {
                1: 'پیش‌فرض (کلاسیک)',
                2: 'فونت زیر (EmadSys)'
            };
            
            const currentTemplate = getSavedTemplate();
            document.getElementById('current_template').textContent = templateNames[currentTemplate];
        };
    </script>
</head>
<body>
    <h1>ارسال توکن</h1>
    
    <div style="margin-bottom: 20px; padding: 10px; background: #f0f2ff; border-radius: 8px;">
        <strong>قالب فعال:</strong> <span id="current_template">بارگذاری...</span>
        <br>
        <small>برای تغییر قالب به صفحه <a href="text.html" target="_blank">text.html</a> مراجعه کنید</small>
    </div>
    
    <input type="text" id="target_guid" placeholder="GUID مقصد" value="u0Dncyz0d8989afff51fe47d218a1795">
    <button onclick="sendToken()">ارسال توکن</button>
</body>
</html>